/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Eco Web controls                 }
{ Copyright (c) 2003 - 2004 Borland Software Corporation}
{                                                       }
{*******************************************************/

using System;
using System.IO;
using System.ComponentModel;
using System.Collections;
using System.Collections.Specialized;
using System.Web.UI;
using System.Reflection;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.Handles;
using System.Globalization;

namespace Borland.Data.Web.Eco
{
	public class EcoHandleCollection : MarshalByRefObject, IList, ICollection, IEnumerable
	{
		private ArrayList m_items = new ArrayList();
		private ArrayList m_names = new ArrayList();
		private EcoPageStateManager FPageStateManager;

		public EcoPageStateManager PageStateManager
		{
			get
			{
				return FPageStateManager;
			}
			set
			{
				FPageStateManager = value;
			}
		}

		protected void UpdateManager()
      {
         if( FPageStateManager != null )
            FPageStateManager.SetupCurrentRow(this);
      }

      public Type ItemType
		{
			get{ return typeof(Borland.Eco.Handles.ElementHandle); }
		}

		public bool IsFixedSize
		{
			get
			{
				return false;
			}
		}

		public bool IsReadOnly
      {
         get
         {
            return false;
         }
      }

      public void Clear()
      {
			m_items.Clear();
			m_names.Clear();
      }

      public Borland.Eco.Handles.ElementHandle this[int index]
      {
         get
			{
				return (Borland.Eco.Handles.ElementHandle) m_items[index];
         }
         set
         {
            m_items[index] = value;
      }
    }

    public Borland.Eco.Handles.ElementHandle this[string index]
    {
      get
      {
        return (Borland.Eco.Handles.ElementHandle) m_items[IndexOf(index)];
      }
      set
      {
        m_items[IndexOf(index)] = value;
      }
    }

    object IList.this[int index]
    {
      get
      {
        return m_items[index];
      }
      set
      {
        m_items[index] = value;
      }
    }

    public object SyncRoot
    {
      get
      {
        return this;
      }
    }

    public bool IsSynchronized
    {
      get
      {
        return false;
      }
    }

    public int Count
    {
      get
      {
        return m_items.Count;
      }
    }

    public void CopyTo(Array array, int index)
    {
      m_items.CopyTo(array, index);
    }

    public IEnumerator GetEnumerator()
    {
      return m_items.GetEnumerator();
    }

	 public void Insert(int index, Object value)
	 {
		m_items.Insert(index, value);
		m_names.Insert(index, null);
		UpdateManager();
    }

    public bool Contains(object value)
    {
      return(-1 != IndexOf(value));
	 }

	 public int Indexof(Borland.Eco.Handles.ElementHandle value)
    {
      int Count = 0;
      while (Count < m_items.Count )
      {
         Borland.Eco.Handles.ElementHandle elHandle = m_items[Count] as Borland.Eco.Handles.ElementHandle;
         if( elHandle == value )
            return Count;
         Count ++;
      }
      return -1;
    }

    public int IndexOf(Object value)
    {
      int Count = 0;
      while (Count < m_items.Count )
      {
        if (value == m_items[Count])
          return Count;
        Count ++;
      }
      return -1;
    }

	 public int IndexOf(string Name)
	 {
		return m_names.IndexOf(Name);
	 }

	 public void RemoveAt(int index)
    {
		m_items.RemoveAt(index);
		m_names.RemoveAt(index);
		UpdateManager();
	 }

	 public void Remove(Object value)
	 {
		int index = IndexOf(value);
		if (index != -1 )
		{
		  m_items.RemoveAt(index);
        m_names.RemoveAt(index);
        return;
      }
    }

	 public void Remove(Borland.Eco.Handles.ElementHandle value)
	 {
		int index = IndexOf(value);
		if (index != -1 )
		{
		  m_items.RemoveAt(index);
		  m_names.RemoveAt(index);
		  UpdateManager();
		  return;
		}
	 }

	 public int Add(Object value)
	 {
		return Add(value, null);
	 }

	 public int Add(Object value, string Name)
	 {
		if(value is Borland.Eco.Handles.ElementHandle)
		{
		  int iAdd = m_items.Add(value);
		  m_names.Add(Name);
		  UpdateManager();
		  return iAdd;
		}
		return -1;
	 }
	 public string GetName(int index)
	 {
		if( m_names[index] == null )
			return null;
		return Convert.ToString(m_names[index]);
	 }

		public int SetName(Page page, string Name)
		{
			int Index = m_names.IndexOf(Name);
			if( Index >= 0 )
				return Index;
			if( !ClassUtils.IsDesignTime(page) )
			{
				Type t = page.GetType();
				FieldInfo info = t.GetField(Name, BindingFlags.Instance | BindingFlags.NonPublic);
				if( info != null )
				{
					Object o = info.GetValue(page);
					if( o != null )
					{
						Index = IndexOf(o);
						if( Index >= 0 )
							SetName(Index, Name);
					}
				}
			}
			else
			{
				for( int i = 0; i < m_items.Count; i++ )
				{
					string Item = (m_items[i] as Component).Site.Name;
					if( Item == Name )
					{
						Index = i;
						SetName(Index, Name);
						break;
					}
				}
			}
			return Index;
		}
	 public string GetName(ElementHandle handle)
	 {
		int index = m_items.IndexOf(handle);
		if( index >= 0 )
			return GetName(index);
		return null;
	 }

	 public int SetName(int index, string Name)
	 {
		 m_names[index] = Name;
		 return index;
	 }

	 public ElementHandle GetHandleByName(string Name)
	 {
		int index = m_names.IndexOf(Name);
		if(index >= 0 )
			return m_items[index] as ElementHandle;
		return null;
	 }

		private int _cultureAwareCompare(string strA, string strB)
		{
			return CultureInfo.CurrentCulture.CompareInfo.Compare(strA, strB, CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | CompareOptions.IgnoreCase);
		}

		public static bool IsValidHandleType(System.Object handle)
		{
			return (handle is Borland.Eco.Handles.RootedHandle);
		}
	}

}
